!#############################################################################
!
! AIX 3.2 Internationalization Sample Environment Package
!
! (C) COPYRIGHT International Business Machines Corp. 1989 All Rights Reserved
!
! US Government Users Restricted Rights - Use, duplication or disclosure 
! restricted by GSA ADP Schedule Contract with IBM Corp.
!
! INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THIS PACKAGE OF SAMPLE
! ENVIRONMENT FILES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, AS IS, 
! WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, BUT NOT
! LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
! PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
! SAMPLE ENVIRONMENT FILES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, IS
! WITH YOU. SHOULD ANY PART OF THE SAMPLE ENVIRONMENT PACKAGE PROVE DEFECTIVE,
! YOU (AND NOT IBM) ASSUME THE ENTIRE COST OF ALL NECESSARY SERVICE, SUPPORT,
! REPAIR OR CORRECTION.
!
! Each copy of the AIX 3.2 ILS Sample Environment Package or derivative work
! thereof must reproduce the IBM Copyright notice and the complete contents of
! this notice.
!
!#############################################################################


! This file describes the changes needed to be done to 
! get a Japanese and/or Korean mapping on a 101/102 
! keyboard using X Windows.
!
!===================== JAPANES =====================
!
! The following are the JP unique keys defined on the 106 JP keyboard
! These are obtained from /usr/lpp/X11/defaults/xmodmap/ja_JP/keyboard, or
!                         /usr/lpp/X11/defaults/xmodmap/Ja_JP/keyboard.
!
!keycode 9  =   Zenkaku_Hankaku NoSymbol        NoSymbol
!keycode 38 =   Katakana        NoSymbol        NoSymbol
!keycode 68 =   Eisu_toggle     NoSymbol        NoSymbol
!keycode 139 =  Muhenkan        NoSymbol        NoSymbol
!keycode 140 =  Henkan          NoSymbol        NoSymbol
!keycode 141 =  Hiragana        NoSymbol        NoSymbol

! The following are the En_US setting for the Numpad
!
!keycode 103 =  KP_Divide       NoSymbol        NoSymbol
!keycode 108 =  KP_Multiply     NoSymbol        NoSymbol
!keycode 113 =  KP_Subtract     NoSymbol        NoSymbol
!keycode 114 =  KP_Add          NoSymbol        NoSymbol


!
!===================== KOREAN ======================
!
! The following are the keys defined on the 106 KR keyboard
! These are obtained from /usr/lpp/X11/defaults/xmodmap/ko_KR/keyboard.
!
! XK_Hangul_Hanja (0xff34)
!keycode 68 =   0xff34          NoSymbol        NoSymbol
!
! Hangul Specific Keys
!
!       Alt_R(70) + CapsLock(38) --> Hangul_Jeonja(108) Conflict w/ JP(108) XK_KP_Separator
!       Alt_R(70) + Hangul_Hanja(68) --> Hangul_Codeinput(138)
!       Alt_R(70) + Hangul_Conversion(140) --> Hangul_MultipleCandidate(210)
!       Alt_R(70) + Hangul(141) --> Hangul_Jamo(211)
!
!       XK_Hangul                       0xff31
!       XK_Hangul_Caps_Lock             0xff32
!       XK_Hangul_Hanja                 0xff34
!       XK_Hangul_Jamo                  0xff35
!       XK_Hangul_Codeinput             0xff37
!       XK_Hangul_Jeonja                0xff38
!       XK_Hangul_Conversion            0xff3a
!       XK_Hangul_NonConversion         0xff3b
!       XK_Hangul_MultipleCandidate     0xff3d
!       XK_Korean_Won                   0xa4
!
! keycode 108 = 0xff38                  NoSymbol        NoSymbol
! XK_Hangul_Codeinput
! keycode 138 = 0xff37                  NoSymbol        NoSymbol
! XK_Hangul_NonConversion
! keycode 139 = 0xff3b                  NoSymbol        NoSymbol
! XK_Hangul_Conversion
! keycode 140 = 0xff3a                  NoSymbol        NoSymbol
! XK_Hangul
! keycode 141 = 0xff31                  NoSymbol        NoSymbol
! XK_Hangul_MultipleCandidate
! keycode 210 = 0xff3d                  NoSymbol        NoSymbol
! Hangul_Jamo
! keycode 211 = 0xff35                  NoSymbol        NoSymbol


!
!===================== REMAP 101 Keyboard =======================
!
! We remap the JP/KR specific keys onto the top for keys of the 
! keypad, i.e. - /,*,-, and +. To actually get these mappings do 
! the following:
!    xmodmap /usr/lpp/X11/defaults/xmodmap/ja_JP/keyboard
!    xmodmap jp.keypad		# this file
!
! NOTE**** To clear locks from Japanese keyboard
!    xmodmap cleanLock
!
! NOTE**** To return to English keyboard:
!    xmodmap /usr/lpp/X11/defaults/xmodmap/en_US/keyboard
!
! The following are mapping of the Japanese keys on a 101/102.
!
! Note: Added KanjiBangou & HenkanMenu to list of keys
! Note: The Korean are added on the ModeSwitch key for the same keys
!        CAREFUL: Some keyboards (JP) do not define ModeSwitch!
!
!		Base		 Shift
!               ------------    ----------------
!keycode 103 =  Eisu_toggle     Zenkaku_Hankaku 0xff31 0xff3c
!keycode 108 =  Katakana        HenkanMenu      0xff34 0xff35
!keycode 113 =  Hiragana        KanjiBangou     0xff37 0xff38
!keycode 114 =  Henkan          Muhenkan        0xff3a 0xff3d

!
! The following mapping of the Korean keys on a 101/102.
! You can uncomment the following to use Korean.  Note, this is not
! 100% tested.  To get Korean map do:
!
!    xmodmap /usr/lpp/X11/defaults/xmodmap/ko_KR/keyboard
!    xmodmap ko.keypad		# this file
!
keycode 103 =  0xff31 0xff3c
keycode 108 =  0xff34 0xff35
keycode 113 =  0xff37 0xff38
keycode 114 =  0xff3a 0xff3d


